/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.process.ospf.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.OSPFAuthType;
import com.cisco.pt.ipc.impl.IPCObjectImpl;
import com.cisco.pt.ipc.sim.process.ospf.OSPFArea;
import com.cisco.pt.ipc.sim.process.ospf.OSPFDatabase;
import com.cisco.pt.ipc.sim.process.ospf.OSPFNeighborTable;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSPFAreaImpl
extends IPCObjectImpl
implements OSPFArea {
    public OSPFAreaImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public IPAddress getAreaId() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAreaId");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }

    @Override
    public void setAuthentication(OSPFAuthType type) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setAuthentication");
        newCall.addIntParameter(type.getIntValue());
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public OSPFAuthType getAuthentication() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAuthentication");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFAreaImpl.getAuthentication");
        }
        return OSPFAuthType.fromIntValue(returnMessage.getIntValue());
    }

    @Override
    public int getConfiguredPortCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getConfiguredPortCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFAreaImpl.getConfiguredPortCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getConfiguredNetworkCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getConfiguredNetworkCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFAreaImpl.getConfiguredNetworkCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public Pair<IPAddress, IPAddress> getConfiguredNetworkAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getConfiguredNetworkAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        Pair rawPair = (Pair)returnMessage.getObjectValue();
        Pair<IPAddress, IPAddress> answer = new Pair<IPAddress, IPAddress>((IPAddress)rawPair.getFirst(), (IPAddress)rawPair.getSecond());
        return answer;
    }

    @Override
    public OSPFNeighborTable getNeighborTable(String portName) {
        return this.getFactory().getNeighborTable(this, portName);
    }

    @Override
    public OSPFDatabase getDatabase() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDatabase");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (OSPFDatabase)returnMessage.getObjectValue();
    }

    @Override
    public int getFloodLength(String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFloodLength");
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFAreaImpl.getFloodLength");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getLastFloodLength(String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getLastFloodLength");
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFAreaImpl.getLastFloodLength");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getLastFloodTime(String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getLastFloodTime");
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFAreaImpl.getLastFloodTime");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getMaxFloodLength(String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getMaxFloodLength");
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFAreaImpl.getMaxFloodLength");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getMaxFloodTime(String portName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getMaxFloodTime");
        newCall.addStringParameter(portName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFAreaImpl.getMaxFloodTime");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getSpfCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSpfCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFAreaImpl.getSpfCount");
        }
        return returnMessage.getIntValue();
    }
}

